/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AnalogDeltaTriggerParameter;
import DE.siemens.ad.logo.model.AnalogFilterParameter;
import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.AsymPulseGeneratorParameter;
import DE.siemens.ad.logo.model.AverageValueParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.ComfortSwitchParameter;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.DataLogParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.LatchingRelayParameter;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.MaxMinParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.OffDelayParameter;
import DE.siemens.ad.logo.model.OnDelayParameter;
import DE.siemens.ad.logo.model.OnOffDelayParameter;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.PWMParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.RampControlParameter;
import DE.siemens.ad.logo.model.RandomParameter;
import DE.siemens.ad.logo.model.RetentiveOnDelayParameter;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.model.ShiftRegisterParameter;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.StairsSwitchParameter;
import DE.siemens.ad.logo.model.StopWatchParameter;
import DE.siemens.ad.logo.model.TriggerParameter;
import DE.siemens.ad.logo.model.WipingRelayPECParameter;
import DE.siemens.ad.logo.model.WipingRelayParameter;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.NetworkNodeBlock;
import DE.siemens.ad.logo.model.block.SOutputBlock;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo6;
import DE.siemens.ad.udf.UDFParameterItem;

public class LinkerToLogo7
extends LinkerToLogo6 {
    public LinkerToLogo7(Hardware hw) {
        super(hw);
    }

    public Object visit(ShiftRegisterParameter param) {
        this.fMemory.put(1 << param.getOutputBit());
        this.fMemory.put(param.getIndex() + 1);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(SoftkeyParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(StopWatchParameter param) {
        this.fMemory.put(param.getOutputTimeBase().getTimeBaseKey());
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(InBlockConnector connector) {
        this.fConnector = connector;
        Block prev = connector.getLinkedBlock();
        while (prev instanceof DeputyBlock) {
            prev = ((DeputyBlock)prev).getInConnector(0).getLinkedBlock();
        }
        if (prev != null) {
            prev.acceptVisitor(this);
        } else {
            int ncCode = this.getNotConnectedCode(connector.isNegated());
            this.setReference(ncCode);
            if (!connector.isNegated()) {
                this.fMemory.put(this.getNotConnectedByte());
            } else {
                this.fMemory.setPosition(this.fMemory.getPosition() - 1);
                this.fMemory.putWord(17407);
            }
        }
        return null;
    }

    public Object visit(OnDelayParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(OffDelayParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(ClockParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(RetentiveOnDelayParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(LatchingRelayParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(HoursCounterParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(WipingRelayParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(CounterParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(DataLogParameter param) {
        return null;
    }

    public Object visit(TriggerParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AsymPulseGeneratorParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(OnOffDelayParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(RandomParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(StairsSwitchParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(ComfortSwitchParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(WipingRelayPECParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(MessageParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AnalogTriggerParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AnalogWatchdogParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AnalogDeltaTriggerParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(RampControlParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(PIDParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AnalogMathsParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(PWMParameter param) {
        super.visit(param);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(MathDetectionParameter param) {
        int progNr = 65535;
        if (param.getReferencedBlockNumber() > 0) {
            progNr = this.convertToPrgLine(param.getReferencedBlockNumber());
        }
        this.fMemory.putWord(progNr);
        this.fMemory.put(param.isAutoResetMode() != false ? 1 : 0);
        this.fMemory.put(255);
        int detectedErr = 0;
        if (param.isDetectOverflow()) {
            ++detectedErr;
        }
        if (param.isDetectZeroDivision()) {
            detectedErr += 2;
        }
        this.fMemory.put(detectedErr);
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AnalogFilterParameter param) {
        this.fMemory.put(Integer.toBinaryString(param.getSampleNumber()).length() - 1);
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(MaxMinParameter param) {
        this.writeWordOrReference(param.getModeProperties());
        this.fMemory.put(param.isResetMaxMin() != false ? 1 : 0);
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AverageValueParameter param) {
        this.fMemory.putWord(param.getSamplingTime().getTime() << 3 | param.getSamplingTime().getTimeBaseKey());
        this.fMemory.putWord(param.getSampleNumber().getCurrentValue());
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AstronomicalClockParameter param) {
        AstronomicalClockParameter.Theodolite longi = param.getLongitude();
        this.fMemory.put(longi.getSecond());
        this.fMemory.put(longi.getMinute());
        this.fMemory.put(longi.getDegree());
        this.fMemory.put(longi.getDir());
        AstronomicalClockParameter.Theodolite lati = param.getLatitude();
        this.fMemory.put(lati.getSecond());
        this.fMemory.put(lati.getMinute());
        this.fMemory.put(lati.getDegree());
        this.fMemory.put(lati.getDir());
        int timeZone = param.getTimeZone().getCurrentValue();
        this.fMemory.put((timeZone >= 0 ? 0 : 128) + Math.abs(timeZone));
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(NetworkNodeBlock block) {
        this.setReference(block.getOpcode(this.fHardware, block.getNumber()));
        this.setReferenceHighByteToNetworkNode();
        return null;
    }

    public Object visit(NetworkNodeParameter block) {
        return null;
    }

    public Object visit(SOutputBlock block) {
        this.setReference(block.getOpcode(this.fHardware, block.getNumber()));
        this.setReferenceHighByteToNetworkNode();
        return null;
    }

    public Object visit(SOutputParameter block) {
        return null;
    }

    protected void setReferenceHighByteToNetworkNode() {
        this.setReferenceHighByte(96, 32);
    }

    protected void setReference(int reference) {
        this.fMemory.putWord(reference);
        int offset = this.fMemory.getPosition();
        this.fMemory.setPosition(offset - 1);
    }

    protected void setReferenceHighByteToProgramLine() {
        this.setReferenceHighByte(192, 128);
    }

    protected void setReferenceHighByteToConstant() {
        this.setReferenceHighByte(64, 0);
    }

    protected void setReferenceHighByte(int nagativeValue, int normalValue) {
        int preValue = this.fMemory.get(this.fMemory.getPosition());
        this.fMemory.put(this.fConnector.isNegated() ? preValue | nagativeValue : preValue | normalValue);
    }

    protected int getNotConnectedCode(boolean isNagative) {
        return this.getNotConnectedByte();
    }

    protected int getNotConnectedByte() {
        return 0;
    }

    protected void writeWordOrReference(IntegerOrBlockReference integerReference) {
        if (integerReference.isReference()) {
            ParameterItem paraItem = integerReference.getReference();
            if (paraItem instanceof UDFParameterItem) {
                paraItem = ((UDFParameterItem)paraItem).getRootSourceParameterItem();
                this.fMemory.putWord(this.convertToPrgLine(paraItem.getParameter().getBlock().getNumber()));
            } else {
                this.fMemory.putWord(this.convertToPrgLine(integerReference.getReferenceToBlock().getNumber()));
            }
        } else {
            this.fMemory.putWord(integerReference.getValue());
        }
    }

    protected void writeDoubleWordOrReference(IntegerOrBlockReference integerReference) {
        if (integerReference.isReference()) {
            ParameterItem paraItem = integerReference.getReference();
            if (paraItem instanceof UDFParameterItem) {
                paraItem = ((UDFParameterItem)paraItem).getRootSourceParameterItem();
                this.fMemory.putDoubleWord(this.convertToPrgLine(paraItem.getParameter().getBlock().getNumber()));
            } else {
                this.fMemory.putDoubleWord(this.convertToPrgLine(integerReference.getReferenceToBlock().getNumber()));
            }
        } else {
            this.fMemory.putDoubleWord(integerReference.getValue());
        }
    }

    protected int getVMReferenceByte(int vmLength) {
        int ret;
        if (vmLength == 1) {
            ret = 0;
        } else if (vmLength == 2) {
            ret = 1;
        } else if (vmLength == 4) {
            ret = 2;
        } else {
            throw new IllegalArgumentException();
        }
        return (4 | ret) << 11;
    }
}

